IF OBJECT_ID ('P_EST_NF_ENT_CONSULTA_NFE') IS NOT NULL 
 BEGIN 
    DROP PROCEDURE P_EST_NF_ENT_CONSULTA_NFE 
 END 
 GO
 
/*
=======================================================================================
'Job.................:  
'Funo..............: Relatrio
'Objetivo............: Calcular o custo do produto 
'Tabelas.............: EST_NF_ENT
'Dt Modificao......: 22/10/2020
'Modificao.........: Tag #A001 a Tag #A002 -  Aumentar tamanho do campo NR_AUTORIZADOR
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
 
CREATE PROCEDURE P_EST_NF_ENT_CONSULTA_NFE ( @CD_FILIAIS 			VARCHAR(MAX), 
											 @DT_INI				DATETIME,
											 @DT_FIM				DATETIME,
											 @MOV 					VARCHAR(MAX),
											 @VISUALIZAR_INTEGRACAO	BIT = NULL,
											 @SEM_CHAVE 			BIT = NULL,
											 @SEM_PRE_ENTRADA		BIT = NULL,
											 @SEM_NOTAS_CANCELADAS  BIT = NULL,
											 @TIPO_DE_PESQUISA 		TINYINT = NULL, /* Reclamem com os */
											 @TIPO_PESQUISA 		TINYINT = NULL, /* programadores da tela */
											 @NR_NF_INI 			INT = NULL,
											 @NR_NF_FIM 			INT = NULL)
AS 
	-- P_EST_NF_ENT_CONSULTA_NFE '1','20210107', '20211010', '1',1,1,1,1,1,1
/*

EXEC P_EST_NF_ENT_CONSULTA_NFE 
	@CD_FILIAIS='1',	@DT_INI='20220113',	@DT_FIM='20220713',	@MOV='176,280,554,387,385,256,415,213,305,245,281,495,178,266,534,421,426,423,59,214,250,22,313,315,319,544,546,210,25,465,493,503,24,148,65,32,383,380,348,303,317,396,389,390,68,33,64,246,549,277,133,402,539,438,251,252,289,291,548,219,386,417,568,565,563,522,523,564,540,212,218,269,469,494,497,526,491,492,333,334,320,321,249,531,457,419,448,230,243,425,485,505,468,308,427,462,463,550,483,510,547,556,479,328,482,454,416,530,278,258,186,234,188,306,529,192,190,182,170,327,240,517,201,300,369,302,455,4,236,247,561,255,552,102,343,411,120,507,174,82,91,80,29,528,172,276,3,17,165,216,221,19,46,433,265,257,373,569,464,323,409,437,47,5,184,173,93,518,470,347,168,200,345,350,429,203,198,12,487,336,262,263,363,70,237,338,558,283,326,275,346,364,285,329,332,331,287,570,288,264,351,211,85,149,39,261,436,242,196,195,42,61,78,147,340,395,392,146,153,95,135,36,51,110,150' ,
	@VISUALIZAR_INTEGRACAO=0,	@SEM_CHAVE=0,	@SEM_PRE_ENTRADA=0,	@SEM_NOTAS_CANCELADAS=1,	@TIPO_DE_PESQUISA=0,	@TIPO_PESQUISA=5,	@NR_NF_INI='',	@NR_NF_FIM=''

*/
	SET NOCOUNT ON;
	DECLARE @TSQL VARCHAR(MAX);
-----------------------------------------------------------------------------------------------------------

	CREATE TABLE #FILIAIS (CD_EMP INT ,CD_FILIAL INT )
	INSERT INTO #FILIAIS 
	SELECT 1,ID FROM UFD_PRM_IN_STRING(@CD_FILIAIS)

	CREATE TABLE #MOV (CD_MOV_OP INT )
	INSERT INTO #MOV 
	SELECT ID FROM UFD_PRM_IN_STRING(@MOV)

-----------------------------------------------------------------------------------------------------------
-- Tag #A001 
	CREATE TABLE #EST_NF_ENT ( CD_EMP            INT
							, CD_FILIAL         INT
							, DT_ENT            DATETIME
							, NR_NF             INT
							, CD_ORIG           INT
							, DT_EMI_NF         DATETIME
							, NM_ORIG           VARCHAR(500)
							, VLR_NF            MONEY
							, DS_MOV_OP         VARCHAR(500)
							, VLR_DESC          MONEY
							, CD_NF             INT
							, NR_AUTORIZADOR    VARCHAR(200)
							, PEND_CROSS        INT
							, TP_MOV            INT
							, CD_PED            INT
							,USU_CHECKIN		VARCHAR(200)
							,USU_ENTRADA		VARCHAR(200)
							, ID_EVENTO         VARCHAR(10)
							, DS_ST_EVENTO      VARCHAR(10)
							, NM_USU            VARCHAR(10)
							, DT_ULT_ALT_EVENTO VARCHAR(10)
						);
--			  ''TESTE'' AS USU_CHECKIN,
-- Tag #A002
	CREATE TABLE #EST_NF_ENT_NR_PROTOCOLO ( CD_EMP         	INT
										, CD_FILIAL      	INT
										, CD_NF          	INT
										, NR_AUTORIZADOR 	VARCHAR(200)
										,USU_CHECKIN		VARCHAR(200)
										);

SET @TSQL = '
	INSERT INTO #EST_NF_ENT
	SELECT EST_NF_ENT.CD_EMP, 
		DBO.EST_NF_ENT.CD_FILIAL, 
		DBO.EST_NF_ENT.DT_ENT, 
		DBO.EST_NF_ENT.NR_NF, 
		DBO.EST_NF_ENT.CD_FORN AS CD_ORIG, 
		DBO.EST_NF_ENT.DT_EMI_NF, 
		V_GLB_PESSOA.RAZAO_SOCIAL_PESSOA AS NM_ORIG, 
		DBO.EST_NF_ENT.VLR_NF, 
		DBO.GLB_MOV_OP.DS_MOV_OP, 
		DBO.EST_NF_ENT.VLR_DESC, 
		DBO.EST_NF_ENT.CD_NF AS CD_NF, 
		'''', 
		ISNULL(EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_NF,0) AS PEND_CROSS,
		DBO.GLB_MOV_OP.TP_MOV, 
		ISNULL(CP.CD_PED, 0) AS CD_PED,
		'''' AS USU_CHECKIN,
		ISNULL((SELECT CAST(CD_USU AS VARCHAR) + '' - '' + NM_USU  FROM GLB_USU WHERE GLB_USU.CD_USU = EST_NF_ENT.CD_USU ),'''') AS NM_USU_ENTRADA,'			  
		;
IF (@VISUALIZAR_INTEGRACAO = 1)
	SET @TSQL = @TSQL + 
						' V_INTEGRA_PACOTES_EVENTOS.ID_EVENTO, 
						V_INTEGRA_PACOTES_EVENTOS.DS_ST_EVENTO,
						V_INTEGRA_PACOTES_EVENTOS.NM_USU,
						V_INTEGRA_PACOTES_EVENTOS.DT_ULT_ALT_EVENTO';
ELSE
	SET @TSQL = @TSQL + ''''' AS ID_EVENTO, 
		'''' AS DS_ST_EVENTO, 
		'''' AS NM_USU, 
		'''' AS DT_ULT_ALT_EVENTO'

SET @TSQL = @TSQL + '
	FROM DBO.EST_NF_ENT
		INNER JOIN #FILIAIS ON 
		DBO.EST_NF_ENT.CD_EMP = #FILIAIS.CD_EMP
		AND  DBO.EST_NF_ENT.CD_FILIAL = #FILIAIS.CD_FILIAL
		
		INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
		
		INNER JOIN #MOV ON GLB_MOV_OP.CD_MOV_OP = #MOV.CD_MOV_OP
		
		INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
		AND DBO.EST_NF_ENT.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE

		LEFT JOIN PRC_FILIAL_PG_FORN FF ON EST_NF_ENT.CD_EMP = FF.CD_EMP
		AND EST_NF_ENT.CD_FORN = FF.CD_FORN
		LEFT JOIN GLB_MOV_OP_TP_MOV ON GLB_MOV_OP.TP_MOV = GLB_MOV_OP_TP_MOV.TP_MOV 
		OUTER APPLY UFD_GLB_PESSOA(EST_NF_ENT.CD_FORN, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
		
		LEFT JOIN
		(
		SELECT V_EST_NF_ENT_IT_PIS_COFINS.CD_EMP, 
			V_EST_NF_ENT_IT_PIS_COFINS.CD_FILIAL, 
			V_EST_NF_ENT_IT_PIS_COFINS.CD_NF, 
			SUM(VLR_BASE_PIS_COFINS) AS VLR_BASE_PIS_COFINS, 
			SUM(VLR_ICMS_ITENS) AS VLR_ICMS_ITENS
		FROM V_EST_NF_ENT_IT_PIS_COFINS
		GROUP BY V_EST_NF_ENT_IT_PIS_COFINS.CD_EMP, 
			V_EST_NF_ENT_IT_PIS_COFINS.CD_FILIAL, 
			V_EST_NF_ENT_IT_PIS_COFINS.CD_NF

		) RSIMPOSTO ON EST_NF_ENT.CD_EMP = RSIMPOSTO.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = RSIMPOSTO.CD_FILIAL
		AND EST_NF_ENT.CD_NF = RSIMPOSTO.CD_NF
		
		LEFT JOIN PG_CRED_EST_NF_ENT ON EST_NF_ENT.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT.CD_NF = PG_CRED_EST_NF_ENT.CD_NF
		
		INNER JOIN PRC_FILIAL ON EST_NF_ENT.CD_EMP = PRC_FILIAL.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		
		LEFT JOIN EST_NF_ENT_DAR ON EST_NF_ENT_DAR.CD_EMP = EST_NF_ENT.CD_EMP
		AND EST_NF_ENT_DAR.CD_FILIAL = EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT_DAR.CD_NF = EST_NF_ENT.CD_NF
		
		LEFT JOIN EST_NF_ENT_EF_NF_CTR_NF ON EST_NF_ENT_EF_NF_CTR_NF.CD_EMP = EST_NF_ENT.CD_EMP
		AND EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL = EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT = EST_NF_ENT.CD_NF
		
		LEFT JOIN EST_NF_ENT_CROSS_DOCKING_PENDENTE ON EST_NF_ENT.CD_EMP = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_EMP 
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_FILIAL 
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_CROSS_DOCKING_PENDENTE.CD_NF'

IF(@VISUALIZAR_INTEGRACAO = 1)
	SET @TSQL = @TSQL + ' LEFT JOIN V_INTEGRA_PACOTES_EVENTOS ON 
						EST_NF_ENT.CD_EMP = V_INTEGRA_PACOTES_EVENTOS.CD_EMP AND 
						EST_NF_ENT.CD_FILIAL = V_INTEGRA_PACOTES_EVENTOS.CD_FILIAL AND 
						EST_NF_ENT.CD_NF = V_INTEGRA_PACOTES_EVENTOS.CD_CTR AND 
						V_INTEGRA_PACOTES_EVENTOS.TABELA IN (''EST_NF_ENT'')'

IF(@SEM_PRE_ENTRADA = 1)
	SET @TSQL = @TSQL + ' LEFT OUTER JOIN EST_NF_ENT_PRE_ENTRADA_EST_NF_ENT ON 
						EST_NF_ENT.CD_EMP = EST_NF_ENT_PRE_ENTRADA_EST_NF_ENT.CD_EMP AND
						EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PRE_ENTRADA_EST_NF_ENT.CD_FILIAL AND
						EST_NF_ENT.CD_NF = EST_NF_ENT_PRE_ENTRADA_EST_NF_ENT.CD_NF'
							
IF(@TIPO_DE_PESQUISA = 1)
	SET @TSQL = @TSQL + ' INNER'
	
IF @TIPO_DE_PESQUISA in (0,2)
	SET @TSQL = @TSQL + ' LEFT OUTER'
	

	SET @TSQL = @TSQL + ' JOIN EST_NF_ENT_PED_CP cp ON
						EST_NF_ENT.CD_EMP = cp.CD_EMP AND
						EST_NF_ENT.CD_FILIAL = cp.CD_FILIAL AND 
						EST_NF_ENT.CD_NF = cp.CD_NF'

SET @TSQL = @TSQL + ' WHERE EST_NF_ENT.CD_EMP = 1              
		AND EST_NF_ENT.DT_ENT BETWEEN '''+CONVERT(VARCHAR,@DT_INI,112) +''' AND '''+CONVERT(VARCHAR,@DT_FIM,112)+'''
		AND EST_NF_ENT.STS_NF = 0'
		
IF (@SEM_NOTAS_CANCELADAS = 1)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.STS_NF = 0'
		
IF(@SEM_PRE_ENTRADA = 1)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT_PRE_ENTRADA_EST_NF_ENT.CD_NF IS NULL'

IF(@TIPO_DE_PESQUISA = 2)
	SET @TSQL = @TSQL + ' AND cp.CD_EMP IS NULL'
	
IF(@TIPO_PESQUISA = 0)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.NR_NF = '+CONVERT(VARCHAR,@NR_NF_INI);
ELSE IF(@TIPO_PESQUISA = 1)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.NR_NF != '+CONVERT(VARCHAR,@NR_NF_INI);
ELSE IF(@TIPO_PESQUISA = 2)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.NR_NF > '+CONVERT(VARCHAR,@NR_NF_INI);
ELSE IF(@TIPO_PESQUISA = 3)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.NR_NF < '+CONVERT(VARCHAR,@NR_NF_INI);
ELSE IF(@TIPO_PESQUISA = 4)
	SET @TSQL = @TSQL + ' AND EST_NF_ENT.NR_NF BETWEEN '+CONVERT(VARCHAR,@NR_NF_INI)+ ' AND ' + CONVERT(VARCHAR,@NR_NF_FIM);

EXEC	(@TSQL)
--select @TSQL

 
/****************************************************************************************************************/
--Gerando o nr protocolo autorizador
/****************************************************************************************************************/


	INSERT INTO #EST_NF_ENT_NR_PROTOCOLO
	SELECT
		EST_NF_ENT.CD_EMP
		, EST_NF_ENT.CD_FILIAL
		, EST_NF_ENT.CD_NF
		, NFE.NR_AUTORIZADOR
		,ISNULL((SELECT CAST(CD_USU AS VARCHAR) + ' - ' + NM_USU  FROM GLB_USU WHERE GLB_USU.CD_USU = MAX(CHECKIN.CD_USU) ),'') AS USU_CHECKIN
	FROM
		#EST_NF_ENT EST_NF_ENT
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF
		
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO NFE ON EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = NFE.CD_CTR
		
		LEFT JOIN EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_NF
		
		LEFT JOIN EST_NF_ENT_NFE ON EST_NF_ENT.CD_EMP = EST_NF_ENT_NFE.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_NFE.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_NFE.CD_NF

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL ON
		EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR = NFE.CD_CTR

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA CHECKIN ON 
		CHECKIN.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR 

	WHERE EST_NF_ENT.CD_EMP = 1
		AND EST_NF_ENT_NFE.CD_EMP IS NULL
		AND EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_EMP IS NULL

GROUP BY EST_NF_ENT.CD_EMP, EST_NF_ENT.CD_FILIAL, EST_NF_ENT.CD_NF, NFE.NR_AUTORIZADOR;

	INSERT INTO #EST_NF_ENT_NR_PROTOCOLO
    SELECT
        EST_NF_ENT.CD_EMP
        , EST_NF_ENT.CD_FILIAL
        , EST_NF_ENT.CD_NF
        , NFE.NR_AUTORIZADOR
		,ISNULL((SELECT CAST(CD_USU AS VARCHAR) + ' - ' + NM_USU  FROM GLB_USU WHERE GLB_USU.CD_USU = MAX(CHECKIN.CD_USU) ),'') AS USU_CHECKIN
    FROM
        #EST_NF_ENT EST_NF_ENT
        INNER JOIN EST_NF_ENT_NFE NFE ON EST_NF_ENT.CD_EMP = NFE.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = NFE.CD_FILIAL
		AND EST_NF_ENT.CD_NF = NFE.CD_NF
        
		LEFT OUTER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON
		EST_NF_ENT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO  ON 
		EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL ON
		EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA CHECKIN ON 
		CHECKIN.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR 

	WHERE EST_NF_ENT.CD_EMP = 1
		AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT IS NULL 

	GROUP BY EST_NF_ENT.CD_EMP, EST_NF_ENT.CD_FILIAL, EST_NF_ENT.CD_NF, NFE.NR_AUTORIZADOR;

	INSERT INTO #EST_NF_ENT_NR_PROTOCOLO
	SELECT
			EST_NF_ENT.CD_EMP
		, EST_NF_ENT.CD_FILIAL
		, EST_NF_ENT.CD_NF
		, NFE.NR_AUTORIZADOR
		,ISNULL((SELECT CAST(CD_USU AS VARCHAR) + ' - ' + NM_USU  FROM GLB_USU WHERE GLB_USU.CD_USU = MAX(CHKSAI.CD_USU) ),'') AS USU_CHECKIN
	FROM
		#EST_NF_ENT EST_NF_ENT
		INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT
		
		INNER JOIN EST_NF_SAI_NFE NFE ON EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP = NFE.CD_EMP
		AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG = NFE.CD_FILIAL
		AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_SAI = NFE.CD_NF

		--- USURIO QUE FEZ CHECKIN ENTRA POR TRANSFERNCIA
		LEFT JOIN EST_NF_SAI_CHECKIN_ENTRADA CHKSAI ON
		CHKSAI.CD_EMP=EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP AND
		CHKSAI.CD_FILIAL=EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG AND
		CHKSAI.CD_NF=EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_SAI 
		--- FIM
		
	WHERE 
		EST_NF_ENT.CD_EMP = 1 
			 
	GROUP BY EST_NF_ENT.CD_EMP, EST_NF_ENT.CD_FILIAL, EST_NF_ENT.CD_NF, NFE.NR_AUTORIZADOR;
			 
	INSERT INTO #EST_NF_ENT_NR_PROTOCOLO
    SELECT
        EST_NF_ENT.CD_EMP
        , EST_NF_ENT.CD_FILIAL
        , EST_NF_ENT.CD_NF
        , EST_NF_ENT_NFE_FORN_VALID.NR_AUTORIZADOR
		,ISNULL((SELECT CAST(CD_USU AS VARCHAR) + ' - ' + NM_USU  FROM GLB_USU WHERE GLB_USU.CD_USU = MAX(CHECKIN.CD_USU) ),'') AS USU_CHECKIN
    FROM
        #EST_NF_ENT EST_NF_ENT
        INNER JOIN EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_NF
        
		INNER JOIN EST_NF_ENT_NFE_FORN_VALID ON EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_EMP = EST_NF_ENT_NFE_FORN_VALID.CD_EMP
		AND EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_FILIAL = EST_NF_ENT_NFE_FORN_VALID.CD_FILIAL
		AND EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_CTR = EST_NF_ENT_NFE_FORN_VALID.CD_CTR
        
		LEFT JOIN EST_NF_ENT_NFE ON EST_NF_ENT.CD_EMP = EST_NF_ENT_NFE.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_NFE.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_NFE.CD_NF
		
        LEFT OUTER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON EST_NF_ENT.CD_EMP = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP
		AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL
		AND EST_NF_ENT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF
		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO NFE ON EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = NFE.CD_CTR

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL ON
		EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR = NFE.CD_CTR

		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA CHECKIN ON 
		CHECKIN.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR 

    WHERE EST_NF_ENT.CD_EMP = 1
		AND EST_NF_ENT_NFE.CD_EMP IS NULL
		AND EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT IS NULL 

GROUP BY EST_NF_ENT.CD_EMP, EST_NF_ENT.CD_FILIAL, EST_NF_ENT.CD_NF, EST_NF_ENT_NFE_FORN_VALID.NR_AUTORIZADOR;
	-------------------------------------------------------------------------------------------------------------
	delete from #EST_NF_ENT_NR_PROTOCOLO where ISNULL(NR_AUTORIZADOR,'')  ='';

	UPDATE A
	SET  NR_AUTORIZADOR = B.NR_AUTORIZADOR
		 ,USU_CHECKIN = B.USU_CHECKIN
	FROM 
		#EST_NF_ENT A
		INNER JOIN #EST_NF_ENT_NR_PROTOCOLO B ON A.CD_EMP = B.CD_EMP
		AND A.CD_FILIAL = B.CD_FILIAL
		AND A.CD_NF = B.CD_NF;

	IF @SEM_CHAVE = 1
		  delete from #EST_NF_ENT where LEN(NR_AUTORIZADOR)>0;
	-------------------------------------------------------------------------------------------------------------


/*************************************************************************************************************************************/

--Resultado final
/*************************************************************************************************************************************/
	SELECT 
		CD_FILIAL, 
		DT_ENT, 
		NR_NF, 
		CD_ORIG, 
		DT_EMI_NF, 
		NM_ORIG, 
		VLR_NF, 
		DS_MOV_OP, 
		VLR_DESC, 
		CD_NF, 
		NR_AUTORIZADOR, 
		PEND_CROSS, 
		TP_MOV, 
		CD_PED, 
		USU_CHECKIN,
		USU_ENTRADA,
		ID_EVENTO, 
		DS_ST_EVENTO, 
		NM_USU, 
		DT_ULT_ALT_EVENTO
	FROM 
		#EST_NF_ENT ;
/*************************************************************************************************************************************/